USE [AWARE]
GO

CREATE TABLE [dbo].[APPLICATION_VERSION](
	[ID] [uniqueidentifier] NOT NULL,
	[VERSION_NUMBER] [varchar](20) NOT NULL,
	[CREATE_DATE] [datetime] NOT NULL,
 CONSTRAINT [PK_APPLICATION_VERSION] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO


ALTER TABLE [dbo].[APPLICATION_VERSION] ADD  CONSTRAINT [DF_APPLICATION_VERSION_ID]  DEFAULT (newid()) FOR [ID]
GO

ALTER TABLE [dbo].[APPLICATION_VERSION] ADD  CONSTRAINT [DF_CREATE_DATE]  DEFAULT (getdate()) FOR [CREATE_DATE]
GO

CREATE PROCEDURE [dbo].[usp_Report_GetApplicationVersion]
AS	
	SELECT max(VERSION_NUMBER) as Application_Version FROM  APPLICATION_VERSION

GO



